function extractEmail(text) {
    var emails = text.match(/([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9._-]+)/gi);
    if (emails != null) return emails[0];
    return "";
}

function extractUrl(text) {
    var urls = text.match(/(https?:\/\/[^\s]+)/g);
    if (urls != null) return urls[0];
    return "";
}



function typeChange() {
    var x = document.getElementById("email_type").value;
    var email = document.getElementById("email_email");

    var length = email.options.length;
    for (i = length - 1; i >= 0; i--) {
        email.options[i] = null;
    }

    var table = $('#example23').DataTable();
    if (x == "SMTP") {
        table = $('#example23').DataTable();
    } else {
        table = $('#example24').DataTable();
    }

    table.rows().every(function(rowIdx, tableLoop, rowLoop) {
        var data = this.data()[0];
        var option = document.createElement("option");
        option.text = data;
        email.add(option);
    });


    var table1 = $('#example25').DataTable();
    var message = document.getElementById("message_list");
    length = message.options.length;
    for (i = length - 1; i >= 0; i--) {
        message.options[i] = null;
    }
    table1.rows().every(function(rowIdx, tableLoop, rowLoop) {
        var data = this.data()[0];
        var option = document.createElement("option");
        option.text = data;
        message.add(option);
    });
}


var sendStatus = false;
var subject = "";
var message = "";
var from = "";
var type = "";

var apikey = "";

var password = "";
var smtp = "";
var port = "";

$('#send').click(function() {
    subject = $('#message_list').val();

    var table1 = $('#example25').DataTable();
    table1.rows().every(function(rowIdx, tableLoop, rowLoop) {
        var data = this.data()[0];
        if (data == subject) {
            message = this.data()[1];
        }
    });

    from = $('#email_email').val();
    type = $('#email_type').val();

    if (type == "SMTP") {
        var table = $('#example23').DataTable();
        table.rows().every(function(rowIdx, tableLoop, rowLoop) {
            if (this.data()[0] == from) {
                password = this.data()[1];
                smtp = this.data()[2];
                port = this.data()[3];
            }
        });
    } else {
        var table = $('#example24').DataTable();
        table.rows().every(function(rowIdx, tableLoop, rowLoop) {
            if (this.data()[0] == from) apikey = this.data()[2];
        });
    }

    console.log(subject + message);

    switch (sendStatus) {
        case false:
            if (subject == "" || message == "") {
                alert("Input Subject and Message!");
                return;
            }
            sendStatus = true;
            document.getElementById("send").innerText = "STOP";
            document.getElementById("send").classList.add('btn-danger');
            sendEmail();
            break;
        case true:
            stopEmail();
            break;
    }
});

function stopEmail() {
    sendStatus = false;
    document.getElementById("send").innerText = "SEND";
    document.getElementById("send").classList.remove('btn-danger');
}

function sendEmail() {

    var table = document.getElementById('contents'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId, header;
    header = rows[0].getElementsByTagName('td');

    for (i = 1, j = rows.length; i < j; ++i) {
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }

        for (k = 0; k < header.length; k++) {
            message = message.replace('%' + header[k].innerHTML.toUpperCase() + '%', cells[k].innerHTML);
            subject = subject.replace('%' + header[k].innerHTML.toUpperCase() + '%', cells[k].innerHTML);
        }
        email = extractEmail(rows[i].innerHTML);

        if (sendStatus == true) {
            if (type == "SMTP") {
                $.post("php/email/php/smtpsend.php", {
                        Email: from,
                        Password: password,
                        SMTP: smtp,
                        Port: port,
                        To: email,
                        Subject: subject,
                        Msg: message
                    },
                    function(data, status) {
                        // document.getElementById("email_status").innerHTML = email;
                    });
            } else {
                $.post("php/email/php/sendsend.php", {
                        from: from,
                        key: apikey,
                        to: email,
                        subject: subject,
                        msg: message
                    },
                    function(data, status) {
                        // document.getElementById("email_status").innerHTML = email;
                    });
            }
        }
    }

    alert("Message has been sent!!!")
    stopEmail();
}




$(document).ready(function() {
    if (isAPIAvailable()) {
        $('#files').bind('change', handleFileSelect);
    }
});

function isAPIAvailable() {
    // Check for the various File API support.
    if (window.File && window.FileReader && window.FileList && window.Blob) {
        // Great success! All the File APIs are supported.
        return true;
    } else {
        return false;
    }
}

function handleFileSelect(evt) {
    var files = evt.target.files; // FileList object
    var file = files[0];

    // read the file contents
    printTable(file);
}

function printTable(file) {
    var reader = new FileReader();
    reader.readAsText(file);
    reader.onload = function(event) {
        var csv = event.target.result;
        var data = $.csv.toArrays(csv);
        var html = '';
        for (var row in data) {
            html += '<tr>\r\n';
            for (var item in data[row]) {
                html += '<td>' + data[row][item] + '</td>\r\n';
            }
            html += '</tr>\r\n';
        }
        $('#contents').html(html);
    };
    reader.onerror = function() {
        alert('Unable to read ' + file.fileName);
    };
}